/*************************************************************************
 * DISCLAIMER *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "flash_operation_api.h"


char const test_data1[256] @0xC000 =               //256 bytes, fixed at 0xC000 in flash
{
 1,  2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,
 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
 33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
 49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
 1,  2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,
 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
 33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
 49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
 1,  2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,
 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
 33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
 49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
 1,  2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,
 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
 33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
 49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
};

char const test_data2[256] @0xC200 =                 //256 bytes fixed at 0xC200 in flash
{
 1,  2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,
 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
 33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
 49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
 1,  2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,
 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
 33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
 49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
 1,  2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,
 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
 33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
 49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
 1,  2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,
 17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
 33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
 49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,

};


char *pData;                 //Point to the data buffer at 0x18C0 which will be updated to flash 

char Counter = 0;            //count the number of key pressed (PTG2 on JS16 demo board), used to generate the different data 
char Update_Flag = 0;        //the flah to update flash, set by pressing the PTG3 on demo board


void Init_Sys(void);
void Mcu_Init(void);
void MCG_Init(void);
void KBI_Init(void);

                                       
void main(void) 
{
  char i;
  char Ret;
  
  Init_Sys();                         //initial the system
  EnableInterrupts;                   //enable interrupts 

  FCDIV=0x4E;                         // PRDIV8=1; DIV[5:0]=14, flash clock should be 150-200kHz
                                      // bus clock=24M, flash clock=fbus/8/(DIV[5:0]+1) 

  for(;;) 
  {
    __RESET_WATCHDOG(); /* feeds the dog */
    
    if(Update_Flag)
      {
        Update_Flag = 0;                            //clear the flag
        pData = Src_Data;                           //point to data buffer at 0x18c0
        
        for(i= 0; i<32; i++)
           *(pData+i)  = (Counter + i);             //fill the data buffer (determined by Counter) which will be written to flash
        
        
        DisableInterrupts;                          //disable the interrupt before the flash operation
        Ret= Flash_Erase((unsigned char*)0xC000);   //erasing the flash page (0xC000-0xC1FF)      
        
        if(Ret== 0x00)                              //program if the flash erasing is successed
        {
          
          Data_Len = 32;                            //the maximum length is 32 bytes
          Obj_Start_Addr = 0xC000;                  //the start address will be programmed
           
          Ret = Flash_Program();                    //call the flash programming routine to write the data (0x18c0) to 0xC000
          
          
          for(i= 0; i<32; i++)                      //re-initialize the data buffer locate 0x18C0
            *(pData+i)  = (0xFF - Counter + i);
          
          Ret = Flash_Program();                    //program the new data to the address from 0xC020
        
        }
        
        Ret= Flash_Erase((unsigned char*)0xC200);   //erase the flash page
        if(Ret== 0x00)                              //if erase the page successfully
        {
          
          Data_Len = 32;
          Obj_Start_Addr = 0xC200;
           
          Ret = Flash_Program();
        }
        
        EnableInterrupts;                          //Enable the interrupt when flash operation is completed
    } 
  } /* loop forever */
  /* please make sure that you never leave main */
}


void Init_Sys(void)
{
	Mcu_Init(); 

	MCG_Init();	          //initialize the MCG to generate 24MHz bus clock

  KBI_Init();
}

void Mcu_Init()
{
	SOPT1 = 0xF2; 			  /*Enable the COP,  and enable the MCU stop mode*/
			                  /*  
                         *  0b00000010
                         *    ||||||||__ bit0:   
                         *    |||||||___ bit1: 
                         *    ||||||____ bit2: 
                         *    |||||_____ bit3: 
                         *    ||||______ bit4: 
                         *    |||_______ bit5: STOP Mode enable
                         *    ||________ bit6: COP configuration
                         *    |_________ bit7: COP configuration
                         */
	SOPT2 = 0x00;
			                  /*  
                         *  0b00000010
                         *    ||||||||__ bit0:   ACIC  		ACMP output connect to TPM channel 0
                         *    |||||||___ bit1:   SPI2FE		SPI2 input filter enable
                         *    ||||||____ bit2:   SPI1FE		SPI1 input filter enable
                         *    |||||_____ bit3:   
                         *    ||||______ bit4: 
                         *    |||_______ bit5:   COPW COP Window
                         *    ||________ bit6:   COPCLKS	COP wactchdog clock select
                         *    |_________ bit7:   COPCLKS	COP wactchdog clock select
                         */
	SPMSC1 = 0x40;
			                  /*  
                         *  0b01000010
                         *    ||||||||__ bit0:   BGBE  		Bandgap Buffer enable
                         *    |||||||___ bit1:   0			
                         *    ||||||____ bit2:   LVDE		Low_Voltage detect enable
                         *    |||||_____ bit3:   LVDSE		Low_Voltage Detect in stop mode
                         *    ||||______ bit4:   LVDRE		Low_Voltage Detect Reset Enable
                         *    |||_______ bit5:   LVWIE		Low_Voltage Warning interrupt Enable
                         *    ||________ bit6:   LVWACK	Low-Voltage Warning Acknowledge
                         *    |_________ bit7:   LVWF		Low_Voltage Warning Flag
                         */
  SPMSC2 = 0x00;
		                  	/*  
                         *  0b01000010
                         *    ||||||||__ bit0:   PPDC  		Partlal Power Down Control
                         *    |||||||___ bit1:   0			
                         *    ||||||____ bit2:   PPDACK	Partlal Power Down Acknowledge
                         *    |||||_____ bit3:   PPDF		partlal Power Down Flag
                         *    ||||______ bit4:   LVWV		Low-Voltage Warning Voltage Select
                         *    |||_______ bit5:   LVDV		Low_Voltage Detect Voltage select
                         *    ||________ bit6:   0
                         *    |_________ bit7:   0
                         */
  

}


void MCG_Init()
{
	/* the MCG is default set to FEI mode, it should be change to FBE mode*/
	MCGC2 = 0x36;
		                  	/*  
                         *  0b01110100
                         *    ||||||||__ bit0:   EREFSTEN	Exernal reference stop enable
                         *    |||||||___ bit1:   ERCLKEN	External reference enable
                         *    ||||||____ bit2:   EREFS		External reference select
                         *    |||||_____ bit3:   LP			Low power select
                         *    ||||______ bit4:   HGO		High gain oscillator select
                         *    |||_______ bit5:   Range		Frequency range select
                         *    ||________ bit6:   BDIV		Bus frequency divider	
                         *    |_________ bit7:   BDIV	
                         */
                         
	while(!(MCGSC & 0x02));		/*ait for the OSC stable*/
		                  	/*  
                         *  0b00000010
                         *    ||||||||__ bit0:   FTRIM		MCG fine trim
                         *    |||||||___ bit1:   OSCINIT	OSC initialization
                         *    ||||||____ bit2:   CLKST		Clock Mode status
                         *    |||||_____ bit3:   CLKST
                         *    ||||______ bit4:   IREFST		Internal reference status
                         *    |||_______ bit5:   PLLST		PLL select status
                         *    ||________ bit6:   LOCK		Lock Status
                         *    |_________ bit7:   LOLS		Loss of lock status
                         */
                         
	MCGC1 = 0x9B;
		                    /*  
                         *  0b10110000
                         *    ||||||||__ bit0:   IREFSTEN	Internal reference stop enable
                         *    |||||||___ bit1:   IRCLKEN	Internal reference clock enable		
                         *    ||||||____ bit2:   IREFS		Internal reference select
                         *    |||||_____ bit3:   RDIV		Reference divider
                         *    ||||______ bit4:   RDIV
                         *    |||_______ bit5:   RDIv
                         *    ||________ bit6:   CLKS		Clock source select
                         *    |_________ bit7:   CLKS
                         */
	
	while((MCGSC & 0x1C ) != 0x08);		/* check the external reference clock is selected or not*/
	
	/* Switch to PBE mode from FBE*/
	MCGC3 = 0x48;
			/*  
                         *  0b01000110
                         *    ||||||||__ bit0:   VDIV		VCO divider
                         *    |||||||___ bit1:   VDIV
                         *    ||||||____ bit2:   VDIV
                         *    |||||_____ bit3:   VDIV
                         *    ||||______ bit4:   0
                         *    |||_______ bit5:   CME		Clock Monitor Enable
                         *    ||________ bit6:   PLLS 		PLL select
                         *    |_________ bit7:   LOLIE		Loss of lock interrupt enable
                         */
	while ((MCGSC & 0x48) != 0x48);		/*wait for the PLL is locked & */

	/*Switch to PEE mode from PBE mode*/
	MCGC1 &= 0x3F;
	while((MCGSC & 0x6C) != 0x6C);

	return;
}

void KBI_Init(void)
{
   PTAPE = 0xC0;      //enable PTG2,3 pull-up resistor
   
   KBISC_KBACK = 1;
   KBIES = 0x00;
   KBIPE = 0xC0;      //enable KBI6,7
   KBISC_KBIE = 1; 
   return;
}

void interrupt 25  Kbi_ISR(void)
{
     if(!PTAD_PTAD6)
        Counter ++;   //increase the counter value
     
     if(!PTAD_PTAD7)
        Update_Flag = 0x01;    //allow to update the flash
     
     KBISC_KBACK = 1;          //clear the KBI interrupt flag
     return;
}
